/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238;

import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.eui.WrongSysOidMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8238.DeviceView.Builder;
import ibm.nways.jdm8238.DeviceView.Chassis;
import ibm.nways.jdm8238.DeviceView.ChassisLike;
import ibm.nways.jdm8238.Jdm8238NicknameTable;
import ibm.nways.jdm8238.Jdm8238SummaryInfo;
import ibm.nways.jdm8238.MibInfo;
import ibm.nways.jdm8238.SummaryInfoLike;
import ibm.nways.jdm8238.eui.ConfigurationGroup;
import ibm.nways.jdm8238.eui.FaultGroup;
import ibm.nways.jdm8238.eui.SecurityGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.applet.Applet;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;

public class Jdm8238
extends JdmBrowser {
    private static final String[] oidsSupported = new String[]{"1.3.6.1.4.1.49.2.3.15"};
    public static final String bundleName = "ibm.nways.jdm8238.Resources";
    public static final ResourceBundle resBundle = ResourceBundle.getBundle("ibm.nways.jdm8238.Resources");
    private Properties properties;
    Serializable sysOid;
    NavigationFolder root;
    GenModel model;
    public int hubType;
    private NavigationBrowser tree;
    private boolean deviceIsUp = false;
    private int device = -1;
    private SnmpContextModel contextModel;
    private ChassisLike chassis;
    private MibInfo mibInfo;
    private SummaryInfoLike summaryInfo;

    public String getModelTypeName() {
        return "ibm.nways.jdm8238.model.Jdm8238";
    }

    protected synchronized SnmpContextModel getContextModel() {
        block2: {
            if (this.contextModel != null) break block2;
            try {
                this.contextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
            }
            catch (Exception exception) {
                this.contextModel = null;
                RAS.logException(19, 5, (Object)this, "getModelTypeName", exception);
            }
        }
        return this.contextModel;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        if (RAS.isEnabled(19, 5)) {
            RAS.enter(19, 5, (Object)this, "getDeviceGraphicPanel");
        }
        long l = System.currentTimeMillis();
        if (this.summaryInfo == null) {
            this.summaryInfo = new Jdm8238SummaryInfo();
        }
        this.mibInfo.clearSummaryInfo();
        this.mibInfo.setSummaryInfo(this.summaryInfo);
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 5)) {
            RAS.trace(19, 5, (Object)this, "getDeviceGraphicPanel", "Time to retrieve summary table -> " + (l2 - l));
        }
        if (this.mibInfo.getErrorStatus()) {
            int n = this.mibInfo.getErrorCode();
            switch (n) {
                case 1: {
                    new BoxDownMsg(this.getFrame(), resBundle.getString("hubs_jma"));
                    break;
                }
                case 2: {
                    new WrongSysOidMsg(this.getFrame(), resBundle.getString("hubs_jma"));
                    break;
                }
                default: {
                    if (RAS.isEnabled(19, 5)) {
                        RAS.trace(19, 5, (Object)this, "getDeviceGraphicPanel", "Unknown MibInfo error code:" + n);
                    }
                    this.sysOid = null;
                }
            }
        }
        GraphicPanel graphicPanel = null;
        try {
            if (this.device >= 0) {
                this.displayMsg(resBundle.getString("startGraphic"));
                l = System.currentTimeMillis();
                if (this.sysOid != null && this.sysOid instanceof OID) {
                    this.chassis = Builder.getInstance().buildChassis(this, this.mibInfo);
                    this.chassis.draw();
                    graphicPanel = this.chassis.getGraphicPanel();
                }
                this.displayMsg(resBundle.getString("endGraphic"));
                l2 = System.currentTimeMillis();
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, (Object)this, "getDeviceGraphicPanel", "Time to draw -> " + (l2 - l));
                }
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 5, (Object)this, "getDeviceGraphicPanel", exception);
        }
        if (RAS.isEnabled(19, 5)) {
            RAS.exit(19, 5, (Object)this, "getDeviceGraphicPanel");
        }
        return graphicPanel;
    }

    private void getInitialDeviceInfo() {
        try {
            ModelInfo modelInfo = this.model.getInfo("Config");
            this.sysOid = modelInfo.get("Config.SysObjectID");
            if (this.sysOid instanceof Timeout || this.sysOid instanceof NotSupported) {
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, (Object)this, "getInitialDeviceInfo", "Can't talk to the Device " + this.sysOid.toString());
                }
                this.deviceIsUp = false;
                new BoxDownMsg(this.getFrame(), resBundle.getString("IBM8238"));
                return;
            }
            if (this.sysOid instanceof OID) {
                this.device = this.checkSysOid();
            }
            if (this.device < 0) {
                RAS.logError(19, 5, (Object)this, "getInitialDeviceInfol", "Unknown sysObjectID -> " + this.sysOid);
                new WrongSysOidMsg(this.getFrame(), resBundle.getString("Jdm8260br"));
                this.deviceIsUp = false;
                return;
            }
            this.deviceIsUp = true;
            return;
        }
        catch (Exception exception) {
            this.deviceIsUp = false;
            RAS.logException(19, 5, (Object)this, "getInitialDeviceInfo", exception);
            return;
        }
    }

    protected NavigationPoint getNavTreeRoot() {
        String string = ((Applet)((Object)this)).getParameter("traces");
        if (string != null && string.equals("on")) {
            RAS.enableTrcLog(19, 5);
            RAS.trace(19, 5, (Object)this, "getNavTreeRoot", "Traces have been turned on");
        }
        if (this.mibInfo == null) {
            this.mibInfo = new MibInfo();
        }
        this.model = (GenModel)this.getModel();
        this.hubType = this.getHubModel();
        this.displayMsg(resBundle.getString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(resBundle.getString("serverDone"));
        this.getInitialDeviceInfo();
        this.displayMsg(resBundle.getString("createNavigationTree"));
        this.root = this.device >= 0 ? new NavigationFolder(resBundle.getString("IBM8238")) : new NavigationFolder(resBundle.getString("Unknown"));
        return this.root;
    }

    protected void getRestOfNavTree() {
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceIsUp) {
            try {
                GenModel genModel = (GenModel)this.model.getComponent("Configuration");
                ConfigurationGroup configurationGroup = new ConfigurationGroup((JdmBrowser)this, genModel);
                configurationGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationGroup);
                this.root.add((NavigationPoint)configurationGroup);
            }
            catch (Exception exception) {
                RAS.logException(19, 5, (Object)this, "getRestOfNavTree", exception);
            }
        } else {
            NavigationFolder navigationFolder = new NavigationFolder(resBundle.getString("configuration"));
            this.root.add((NavigationPoint)navigationFolder);
            NavigationFolder navigationFolder2 = new NavigationFolder(resBundle.getString("system"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder.add((NavigationPoint)navigationFolder2);
            NavigationFolder navigationFolder3 = new NavigationFolder(resBundle.getString("general"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.add((NavigationPoint)navigationFolder3);
            SnmpContextModel snmpContextModel = this.getContextModel();
            navigationFolder3.add((NavigationPoint)new NavigationItem(resBundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "Administration"));
            navigationFolder3.add((NavigationPoint)new NavigationItem(resBundle.getString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", (RemoteModel)snmpContextModel), "Performance Configuration"));
            NavigationItem navigationItem = new NavigationItem(resBundle.getString("communications"), (NavigationDestination)new MessageDestination(resBundle.getString("notConfigured")));
            navigationFolder.add((NavigationPoint)navigationItem);
        }
        this.buildFaultFolder(this.root);
        this.buildSecurityFolder(this.root);
        this.buildTools(this.root);
        this.displayMsg(resBundle.getString("initDone"));
        if (this.chassis != null) {
            ((Chassis)this.chassis).startStatusThread((Chassis)this.chassis);
        }
    }

    private void buildTools(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = new NavigationFolder(resBundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            TelnetContext telnetContext;
            ResourceBundle resourceBundle;
            SnmpContextModel snmpContextModel = this.getContextModel();
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            WebContext webContext = new WebContext(string);
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            webContext.only_nhd_url();
            NavigationItem navigationItem = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            if (this.getIsApplication()) {
                resourceBundle = new AnalyzerJdmContext(string, this.getServerPortNumber());
                telnetContext = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = telnetContext.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)resourceBundle);
                navigationFolder2.add((NavigationPoint)telnetContext);
            }
            resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            telnetContext = new TelnetContext(string);
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            Browser browser = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 5, (Object)this, "buildTools", exception);
            return;
        }
    }

    private void buildFaultFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.model.getComponent("Traps");
        }
        catch (Exception exception) {
            RAS.logException(19, 5, (Object)this, "buildFaultFolder", exception);
        }
        if (genModel != null) {
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, this.model);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        navigationFolder.add((NavigationPoint)new NavigationItem(resBundle.getString("fault"), (NavigationDestination)new MessageDestination(resBundle.getString("notConfigured"))));
    }

    private void buildSecurityFolder(NavigationFolder navigationFolder) {
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.model.getComponent("SecurityFolder");
        }
        catch (Exception exception) {
            RAS.logException(19, 5, (Object)this, "buildSecurityFolder", exception);
        }
        SecurityGroup securityGroup = new SecurityGroup((JdmBrowser)this, genModel);
        securityGroup.setIsInitiallyExpanded(false);
        this.tree.addEventListener((NavigationBrowserEventListener)securityGroup);
        navigationFolder.add((NavigationPoint)securityGroup);
    }

    public int getHubModel() {
        if (RAS.isEnabled(19, 5)) {
            RAS.enter(19, 5, (Object)this, "getHubModel");
        }
        this.sysOid = null;
        Jdm8238NicknameTable jdm8238NicknameTable = new Jdm8238NicknameTable();
        this.mibInfo.setModelAndNicknames(this.model, jdm8238NicknameTable);
        Serializable serializable = this.mibInfo.getVar("sysOid");
        if (serializable instanceof SpecialValue) {
            this.mibInfo.setErrorCode(1);
            if (RAS.isEnabled(19, 5)) {
                RAS.exit(19, 5, (Object)this, "getHubModel");
            }
            return -1;
        }
        String string = serializable.toString();
        this.sysOid = string;
        if (RAS.isEnabled(19, 5)) {
            RAS.exit(19, 5, (Object)this, "getHubModel");
        }
        return Jdm8238SummaryInfo.modelFromSysOid(string);
    }

    private int checkSysOid() {
        int n = -1;
        try {
            int n2 = 0;
            while (true) {
                if (this.sysOid.toString().equals(oidsSupported[n2])) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        return n;
    }

    public void dispose() {
        this.sysOid = null;
        this.root = null;
        this.model = null;
        this.tree = null;
        this.contextModel = null;
        if (this.mibInfo != null) {
            this.mibInfo.dispose();
        }
        this.mibInfo = null;
        if (this.summaryInfo != null) {
            this.summaryInfo.dispose();
        }
        this.summaryInfo = null;
        super.dispose();
    }

    public Properties getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        try {
            URL uRL = new URL(((Applet)((Object)this)).getDocumentBase(), "properties/Jdm8238.txt");
            Properties properties = new Properties();
            properties.load(uRL.openStream());
            this.properties = properties;
            return properties;
        }
        catch (Exception exception) {
            RAS.logException(19, 5, (Object)this, "getProperties", exception);
            return null;
        }
    }
}

